#ifndef GST_MOMAPROPERTYDESC_H
#define GST_MOMAPROPERTYDESC_H

#include <Client/ClientUtils/MoMaStructs.h>
#include <Client/ClientUtils/Network/TableConstrainedAttributeDesc.h>
#include <buildspec.h>
#include <config.h>

#include <boost/shared_ptr.hpp>

#include <string>
#include <vector>

using GST::ClientUtils::Owner;
using GST::ClientUtils::OwnerPtr;

namespace GST
{
namespace ClientUtils
{
class GST_API_EXPORT MoMaPropertyDesc
	: public TableAttributeDesc
	, public TableConstrainedAttributeDesc
{
public:
	typedef long PROPERTYID;

private:
	OwnerPtr owner;

public:
	bool isConstrained;
	MoMaPropertyDesc(void) = delete;
	MoMaPropertyDesc(const TableAttributeDesc &desc, OwnerPtr owner);
	MoMaPropertyDesc(const TableAttributeDesc &desc,
					 const TableConstrainedAttributeDesc &cp_desc,
					 OwnerPtr owner);
	MoMaPropertyDesc(const MoMaPropertyDesc &other);
	PROPERTYID getMoMaPropertryID() const;
	OwnerPtr getOwner() const;
	void setOwner(const OwnerPtr _owner);
	void setMoMaPropertyID(MoMaPropertyDesc::PROPERTYID _id);
	std::string getMoMaPropertyName() const;
	void setMoMaPropertyName(std::string &newname);
	~MoMaPropertyDesc(void);
	bool operator==(const MoMaPropertyDesc &other) const;
};

typedef boost::shared_ptr<MoMaPropertyDesc> MoMaPropertyDescPtr;
typedef std::vector<MoMaPropertyDescPtr> MoMaPropertyDescList;
typedef boost::shared_ptr<MoMaPropertyDescList> MoMaPropertyDescListPtr;

} // namespace ClientUtils
} // namespace GST

#endif // GST_MOMAPROPERTYDESC_H
